/*
  LuxTag Material.js
  
*/

// global variables.
var version_num = "0.1";

// substrate -> glossy
var material_types = ["carpaint", "glass", "matte", "mattetranslucent", "metal", "mirror", "roughglass", "shinymetal", "glossy", "mix"];

// sub option
var carpaint_names = ["ford f8", "polaris silber", "opel titan", "bmw339", "2k acrylack", "white", "blue", "blue matte", "edit after exporting.."];
var metal_names = ['amorphous carbon', 'silver', 'gold', 'copper', 'aluminium'];

// IOR cauchy
var cauchybnames = ["01 - Fused silica glass", "02 - Borosilicate glass BK7", "03 - Hard crown glass K5", "04 - Barium crown glass BaK4", "05 - Barium flint glass BaF10", "06 - Dense flint glass SF10", "07 - select cauchyb channel" ]
var cauchybvals = [ 0.00354, 0.00420, 0.00459, 0.00531, 0.00743, 0.01342, -1 ]

// Clip map
var clip_maps = ['none','colorTex','specTex','reflTex','transTex'];
var clip_labels = ['none', 'ColorMap', 'SpecMap', 'ReflMap', 'TransMap'];

var channel_color = ['none', 'colorColor', 'specularColor', 'emissionColor', 'none', 'reflColor', 'transColor'];
var channel_map = ['none', 'colorTex', 'specTex', 'none', 'bumpTex', 'reflTex', 'transTex'];
var channel_mix = ['none', 'colorMix', 'specMix', 'none', 'none', 'reflMix', 'transMix'];
var channel_intensity = ['none', 'none', 'none', 'none', 'bumpIntensity', 'reflIntensity', 'transIntensity'];
var channel_labels = ['none', 'ColorChannel', 'SpecularChannel', 'EmissiveChannel', 'BumpChannel', 'ReflChannel', 'TransChannel'];

function setPreset( tag ) {
	var matType = material_types[ parseInt(tag.getParameter("material type")) ];
	
	tag.setParameter("Kd channel", 0);
	tag.setParameter("Kr channel", 0);
	tag.setParameter("Kt channel", 0);
	tag.setParameter("Ks channel", 0);
	tag.setParameter("Ka channel", 0);
	tag.setParameter("d channel", 0);
	tag.setParameter("bumpmap channel", 0);
	tag.setParameter("emission channel", 0);
	tag.setParameter("uroughness channel", 0);
	tag.setParameter("vroughness channel", 0);
	tag.setParameter("sigma channel", 0);
	tag.setParameter("chromadisp", false);
	tag.setParameter("use film", false);
	
	switch( matType) {
		case 'carpaint':
			break;
		case 'glass':
			tag.setParameter("Kr channel", 5);
			tag.setParameter("Kt channel", 6);
			break;
		case 'glossy':
			tag.setParameter("Kd channel", 1);
			tag.setParameter("Ks channel", 2);
			tag.setParameter("Ka channel", 5);
			tag.setParameter("d channel", 6);
			break;
		case 'matte':
			tag.setParameter("Kd channel", 1);
			tag.setParameter("sigma channel", 2);
			break;
		case 'mattetranslucent':
			tag.setParameter("Kr channel", 5);
			tag.setParameter("Kt channel", 6);
			tag.setParameter("sigma channel", 2);
			break;
		case 'metal':
			tag.setParameter("uroughness channel", 2);
			tag.setParameter("vroughness channel", 2);
			break;
		case 'mirror':
			tag.setParameter("Kr channel", 5);
			break;
		case 'roughglass':
			tag.setParameter("Kr channel", 5);
			tag.setParameter("Kt channel", 6);
			tag.setParameter("uroughness channel", 2);
			tag.setParameter("vroughness channel", 2);
			break;
		case 'shinymetal':
			tag.setParameter("Kr channel", 1);
			tag.setParameter("Ks channel", 5);
			tag.setParameter("uroughness channel", 2);
			tag.setParameter("vroughness channel", 2);
			break;
		case 'mix':
			break;
		case 'null':
			OS.messageBox("-- null --", "");
			break;
		default:
			OS.beep();
	}
}

function buildUI( tag ) {
	
	tag.addParameterSeparator("[ Lux Material ]");
	
	//tag.addParameterSelector("shadeSelection", ["all", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"], true, false); // cause error :p
	tag.addParameterInt("shade selection", -1, -1, 15, true, false);
	
	tag.addParameterSeparator("[ Material option ]");
	tag.addParameterSelector("material type", material_types, true, false);
	tag.addParameterButton("set material preset", "set", "setPreset");
	
	tag.addParameterSeparator("imagemap setting");
	tag.addParameterBool("use imagemap gamma", 0, 0, 1, true, false);
	tag.addParameterFloat("imagemap gamma", 2.2, 0, 6, true, false);
	
	tag.addParameterSeparator("material channels");
	
	tag.addParameterSelector("Kd channel", channel_labels, true, false);
	tag.addParameterSelector("Kr channel", channel_labels, true, false);
	tag.addParameterSelector("Kt channel", channel_labels, true, false);
	tag.addParameterSelector("Ks channel", channel_labels, true, false);
	tag.addParameterSelector("Ka channel", channel_labels, true, false);
	
	tag.addParameterSelector("d channel", channel_labels, true, false);
	
	tag.addParameterSelector("bumpmap channel", channel_labels, true, false);
	
	tag.addParameterSelector("clipmap channel", clip_labels, true, false);
	
	tag.addParameterSelector("uroughness channel", channel_labels, true, false);
	tag.addParameterSelector("vroughness channel", channel_labels, true, false);
	tag.addParameterSelector("sigma channel", channel_labels, true, false);
	tag.addParameterFloat("sigma value", 0, 0, 100, true, false);
	
	tag.addParameterBool("use alter ior", 0, 0, 1, true, false);
	tag.addParameterFloat("alter ior", 1.0, 1.0, 6.0, true, false);
	
	tag.addParameterBool("chromadisp",  0, 0, 1, true, false);
	tag.addParameterSelector("cauchyb", cauchybnames, true, false);
	tag.addParameterSelector("cauchyb channel", channel_labels, true, false);
	
	tag.addParameterBool("use film", 0, 0, 1, true, false);
	tag.addParameterFloat("film", 200, 0, 1500, true, false);
	tag.addParameterFloat("film ior", 1.5, 1.0, 6.0, true, false);
	
	tag.addParameterSeparator("carpaint option");
	tag.addParameterSelector("carpaint name", carpaint_names, true, false);
	
	tag.addParameterSeparator("glass option");
	tag.addParameterBool("architectural", 0, 0, 1, true, false);
	
	tag.addParameterSeparator("metal option");
	tag.addParameterSelector("metal name", metal_names, true, false);
	
	tag.addParameterSeparator("mix option");
	tag.addParameterFloat("mix amount", 0.5, 0, 1, true, false);
	
	tag.addParameterSeparator("subdivision option");
	tag.addParameterInt("subdiv levels", 0, 0, 12, true, false);
	tag.addParameterBool("subdiv sharpbound", 0, 0, 1, true, false);
	tag.addParameterBool("subdiv nsmooth", 1, 0, 1, true, false);
	
	tag.addParameterSeparator("displacementmap option");
	tag.addParameterSelector("displacementmap channel", channel_labels, true, false);
	tag.addParameterFloat("disp amount",0.1, -10, 10, true, false);
	tag.addParameterFloat("disp offset", 0, 0, 1, true, false);
	
	tag.addParameterSeparator("emission option");
	tag.addParameterSelector("emission channel", channel_labels, true, false);
	tag.addParameterFloat("power", 100, 0, 10000, true, false);
	tag.addParameterFloat("efficacy", 17, 0, 100, true, false);
	tag.addParameterFloat("gain", 1, 0, 100, true, false);
	
}